
#include <stdio.h>
#include <ncurses.h>
#include <string.h>
#include "menu.h"

#define WIDTH 30
#define HEIGHT 10 

int startx = 0;
int starty = 0;

char *choices[] = { 
			"Choice 1",
			"Choice 2",
			"Choice 3",
			"Choice 4",
			"Exit",
		  };
int n_choices = sizeof(choices) / sizeof(char *);

menustate state;

static void replace_special(char* ptr, int len) {
  int i;
  for( i = 0; i < len-1; ++i ) {
    if( ptr[i] == 'N' && ptr[i+1] == '@' ) {
      ptr[i] = 'M';
      memmove(ptr+i+1, ptr+i+2, len-i-1);
      --len;
    } else if( ptr[i] == 'U' && ptr[i+1] == ':' ) {
      ptr[i] = 'W';
      memmove(ptr+i+1, ptr+i+2, len-i-1);
      --len;
    }
  }
  while( strlen(ptr) < 6 )
    strcat(ptr, " ");
}

int main() {
	int highlight = 1;
	int choice = 0;
	int c;
	char buf[7], flashing[7];

	init_menu(mainmenu, &state);

	initscr();
	clear();
	noecho();
	cbreak();	/* Line buffering disabled. pass on everything */

	while(1) {
        	show_menu(mainmenu, &state, buf, flashing);
        	buf[6] = '\0';
        	flashing[6] = '\0';
        	replace_special(buf, 6);
        	mvprintw(0, 0, buf);
        	mvprintw(1, 0, flashing);
        	refresh();

		c = getch();
//		printf("%d\n", c);
	        if( !handle_menu_keypress(mainmenu, &state, c) )
	                break;
	}	
	clrtoeol();
	refresh();
	endwin();
	return 0;
}
